% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtype.cluster.predict.R
\name{subtype.cluster.predict}
\alias{subtype.cluster.predict}
\title{Function to identify breast cancer molecular subtypes using
the Subtype Clustering Model}
\usage{
subtype.cluster.predict(sbt.model, data, annot, do.mapping = FALSE,
  mapping, do.prediction.strength = FALSE,
  do.BIC = FALSE, plot = FALSE, verbose = FALSE)
}
\arguments{
\item{sbt.model}{Subtype Clustering Model as returned by subtype.cluster.}

\item{data}{Matrix of gene expressions with samples in rows and probes in
columns, dimnames being properly defined.}

\item{annot}{Matrix of annotations with at least one column named
"EntrezGene.ID", dimnames being properly defined.}

\item{do.mapping}{TRUE if the mapping through Entrez Gene ids must be
performed (in case of ambiguities, the most variant probe is kept
for each gene), FALSE otherwise.}

\item{mapping}{\strong{DEPRECATED} Matrix with columns "EntrezGene.ID" and
"probe" used to force the mapping such that the probes are not selected
based on their variance.}

\item{do.prediction.strength}{TRUE if the prediction strength must be
computed (Tibshirani and Walther 2005), FALSE otherwise.}

\item{do.BIC}{TRUE if the Bayesian Information Criterion must be computed
for number of clusters ranging from 1 to 10, FALSE otherwise.}

\item{plot}{TRUE if the patients and their corresponding subtypes must
be plotted, FALSE otherwise.}

\item{verbose}{TRUE to print informative messages, FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item subtype: Subtypes identified by the Subtype Clustering Model.
Subtypes can be either "ER-/HER2-", "HER2+" or "ER+/HER2-".
\item subtype.proba: Probabilities to belong to each subtype estimated
by the Subtype Clustering Model.
\item prediction.strength: Prediction strength for subtypes.
\item BIC: Bayesian Information Criterion for the Subtype Clustering Model
with number of clusters ranging from 1 to 10.
\item subtype2: Subtypes identified by the Subtype Clustering Model using
AURKA to discriminate low and high proliferative tumors. Subtypes can be
either "ER-/HER2-", "HER2+", "ER+/HER2- High Prolif" or
"ER+/HER2- Low Prolif".
\item subtype.proba2: Probabilities to belong to each subtype (including
discrimination between lowly and highly proliferative ER+/HER2- tumors,
see subtype2) estimated by the Subtype Clustering Model.
\item prediction.strength2: Prediction strength for subtypes2.
\item module.scores: Matrix containing ESR1, ERBB2 and AURKA module scores.
\item mapping: Mapping if necessary (list of matrices with 3 columns: probe,
EntrezGene.ID and new.probe).
}
}
\description{
This function identifies the breast cancer molecular subtypes using a
Subtype Clustering Model fitted by subtype.cluster.
}
\examples{
# without mapping (affy hgu133a or plus2 only)
# load VDX data
data(vdxs)
data(scmgene.robust)

# Subtype Clustering Model fitted on EXPO and applied on VDX
sbt.vdxs <- subtype.cluster.predict(sbt.model=scmgene.robust, data=data.vdxs,
  annot=annot.vdxs, do.mapping=FALSE, do.prediction.strength=FALSE,
  do.BIC=FALSE, plot=TRUE, verbose=TRUE)
table(sbt.vdxs$subtype)
table(sbt.vdxs$subtype2)

# with mapping
# load NKI data
data(nkis)
# Subtype Clustering Model fitted on EXPO and applied on NKI
sbt.nkis <- subtype.cluster.predict(sbt.model=scmgene.robust, data=data.nkis,
  annot=annot.nkis, do.mapping=TRUE, do.prediction.strength=FALSE,
  do.BIC=FALSE, plot=TRUE, verbose=TRUE)
table(sbt.nkis$subtype)
table(sbt.nkis$subtype2)

}
\references{
Desmedt C, Haibe-Kains B, Wirapati P, Buyse M, Larsimont D, Bontempi G,
Delorenzi M, Piccart M, and Sotiriou C (2008) "Biological processes
associated with breast cancer clinical outcome depend on the molecular
subtypes", Clinical Cancer Research, 14(16):5158-5165.
Wirapati P, Sotiriou C, Kunkel S, Farmer P, Pradervand S, Haibe-Kains B,
Desmedt C, Ignatiadis M, Sengstag T, Schutz F, Goldstein DR, Piccart MJ
and Delorenzi M (2008) "Meta-analysis of Gene-Expression Profiles in
Breast Cancer: Toward a Unified Understanding of Breast Cancer Sub-typing
and Prognosis Signatures", Breast Cancer Research, 10(4):R65.
Tibshirani R and Walther G (2005) "Cluster Validation by Prediction
Strength", Journal of Computational and Graphical Statistics,
14(3):511-528
}
\seealso{
\link{subtype.cluster}, \link{scmod1.robust}, \link{scmod2.robust}
}
