% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.m.file.R
\name{read.m.file}
\alias{read.m.file}
\title{Function to read a 'csv' file containing gene lists (aka gene signatures)}
\usage{
read.m.file(file, ...)
}
\arguments{
\item{file}{Filename of the 'csv' file.}

\item{...}{Additional parameters for read.csv function.}
}
\value{
List of gene signatures.
}
\description{
This function allows for reading a 'csv' file containing gene signatures.
Each gene signature is composed of at least four columns: "gene.list" is the name
of the signature on the first line and empty fields below, "probes" are the probe
names, "EntrezGene.ID" are the EntrezGene IDs and "coefficient" are the coefficients
of each probe.
}
\examples{
# read the seven gene modules as published in Desmedt et al 2008
genemods <- read.m.file(system.file("extdata/desmedt2008_genemodules.csv",
  package = "genefu"))
str(genemods, max.level=1)
# read the three subtype signtaures from GENIUS
geniusm <- read.m.file(system.file("extdata/haibekains2009_sig_genius.csv",
  package = "genefu"))
str(geniusm, max.level=1)

}
\seealso{
\link{mod1}, \link{mod2}, 'extdata/desmedt2008_genemodules.csv', 'extdata/haibekains2009_sig_genius.csv'
}
