% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps.cluster.R
\name{ps.cluster}
\alias{ps.cluster}
\title{Function to compute the prediction strength of a clustering model}
\usage{
ps.cluster(cl.tr, cl.ts, na.rm = FALSE)
}
\arguments{
\item{cl.tr}{Clusters membership as defined by the original clustering model, i.e.
the one that was not fitted on the dataset of interest.}

\item{cl.ts}{Clusters membership as defined by the clustering model fitted on the
dataset of interest.}

\item{na.rm}{TRUE if missing values should be removed, FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item ps: the overall prediction strength (minimum of the prediction strengths at cluster level).
\item ps.cluster: Prediction strength for each cluster
\item ps.individual: Prediction strength for each sample.
}
}
\description{
This function computes the prediction strength of a clustering model as published
in R. Tibshirani and G. Walther 2005.
}
\examples{
# load SSP signature published in Sorlie et al. 2003
data(ssp2003)
# load NKI data
data(nkis)
# SP2003 fitted on NKI
ssp2003.2nkis <- intrinsic.cluster(data=data.nkis, annot=annot.nkis,
  do.mapping=TRUE, std="robust",
  intrinsicg=ssp2003$centroids.map[ ,c("probe", "EntrezGene.ID")],
  number.cluster=5, mins=5, method.cor="spearman",
  method.centroids="mean", verbose=TRUE)
# SP2003 published in Sorlie et al 2003 and applied in VDX
ssp2003.nkis <- intrinsic.cluster.predict(sbt.model=ssp2003,
  data=data.nkis, annot=annot.nkis, do.mapping=TRUE, verbose=TRUE)
# prediction strength of sp2003 clustering model
ps.cluster(cl.tr=ssp2003.2nkis$subtype, cl.ts=ssp2003.nkis$subtype,
  na.rm = FALSE)

}
\references{
R. Tibshirani and G. Walther (2005) "Cluster Validation by Prediction Strength",
Journal of Computational and Graphical Statistics, 14(3):511-528.
}
