% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneid.map.R
\name{geneid.map}
\alias{geneid.map}
\title{Function to find the common genes between two datasets or a dataset and
a gene list}
\usage{
geneid.map(geneid1, data1, geneid2, data2, verbose = FALSE)
}
\arguments{
\item{geneid1}{First vector of Entrez Gene ids. The name of the vector cells must
be the name of the probes in the dataset data1.}

\item{data1}{First dataset with samples in rows and probes in columns. The dimnames
must be properly defined.}

\item{geneid2}{Second vector of Entrez Gene ids. The name of the vector cells must
be the name of the probes in the dataset data1 if it is not missing, proper names must be assigned otherwise.}

\item{data2}{First dataset with samples in rows and probes in columns. The dimnames
must be properly defined. It may be missing.}

\item{verbose}{TRUE to print informative messages, FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item geneid1 Mapped gene list from geneid1.
\item data1 Mapped dataset from data1.
\item geneid2 Mapped gene list from geneid2.
\item data2 Mapped dataset from data2.
}
}
\description{
This function allows for fast mapping between two datasets or a dataset and a gene
list. The mapping process is performed using Entrez Gene id as reference. In case of
ambiguities (several probes representing the same gene), the most variant probe is
selected.
}
\note{
It is mandatory that the names of geneid1 and geneid2 must be the probe names
of the microarray platform.
}
\examples{
# load NKI data
data(nkis)
nkis.gid <- annot.nkis[ ,"EntrezGene.ID"]
names(nkis.gid) <- dimnames(annot.nkis)[[1]]
# load GGI signature
data(sig.ggi)
ggi.gid <- sig.ggi[ ,"EntrezGene.ID"]
names(ggi.gid) <- as.character(sig.ggi[ ,"probe"])
# mapping through Entrez Gene ids of NKI and GGI signature
res <- geneid.map(geneid1=nkis.gid, data1=data.nkis,
  geneid2=ggi.gid, verbose=FALSE)
str(res)

}
