% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanPeakLengthPlot.r
\name{meanPeakLengthPlot}
\alias{meanPeakLengthPlot}
\title{Produces line plots of mean (average) peak length within any genomic interval.}
\usage{
meanPeakLengthPlot(organism, start, end, by)
}
\arguments{
\item{organism}{Object name assigned from readGFF() command.}

\item{start}{Lower bound of upstream extension.}

\item{end}{Upper bound of upstream extension.}

\item{by}{Interval between consecutive extensions.}
}
\value{
Creates mean peak length line plots.
}
\description{
Makes line plots of mean peak lengths to show the average length of individual peaks within any genomic interval (e.g., 0-500 bp upstream of nearest gene for all genes throughout the genome).
}
\examples{
library(rtracklayer)
rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz")
allpeaks <- system.file("extdata", "totalpeaksfile.txt", package="geneXtendeR")
peaksInput(allpeaks)
meanPeakLengthPlot(rat, 0, 10000, 500)


}
