% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumlinePlot.r
\name{cumlinePlot}
\alias{cumlinePlot}
\title{Produces cumulative line plots.}
\usage{
cumlinePlot(organism, start, end, by)
}
\arguments{
\item{organism}{Object name assigned from readGFF() command.}

\item{start}{Lower bound of upstream extension.}

\item{end}{Upper bound of upstream extension.}

\item{by}{Interval between consecutive extensions.}
}
\value{
Creates cumulative differential line plots.
}
\description{
Makes cumulative differential line plots showing the cumulative sums of the number of genes under peaks at consecutive upstream extension levels.
}
\examples{
library(rtracklayer)
rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz")
fpath <- system.file("extdata", "somepeaksfile.txt", package="geneXtendeR")
peaksInput(fpath)
cumlinePlot(rat, 1000, 3000, 100)


}
