% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_FixedExpressionData.R
\docType{class}
\name{FixedExpressionData}
\alias{FixedExpressionData}
\title{An S4 class to store classifier parameters.}
\description{
This class stores gene expression data together with 
information on the normalization method and additional normalization related 
parameters. In order to ensure the data is not manipulated in unforeseen 
ways, manipulation is strictly controled through adding transformations 
which are predefined in the \code{TransformationProcess}-class. Upon reading
the data by the \code{exprs} function, the transformations areperformed in
the order the were added.
}
\section{Slots}{

\describe{
\item{\code{normalizationMethod}}{A character string indicating the normalization
method that was applied to the data. Possible values are give by 
\code{\link{getNormalizationMethods}}.}

\item{\code{expressionEnvironment}}{A locked environment in which the expression
matrix is stored.}

\item{\code{normalizationParameters}}{A list with normalization specific values.}

\item{\code{transformationProcess}}{A locked environment to which the transformation
processes are added.}

\item{\code{.geneClassifierVersion}}{An object of class \code{\link{package_version}}}
}}

