% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_ClassifierParameters.R
\docType{class}
\name{ClassifierParameters}
\alias{ClassifierParameters}
\title{An S4 class to store classifier parameters.}
\description{
This class stores classifier related information
This is information on probe-sets used and their weightings,
means, standard deviations and covariance structure as observed in
the classifiers training data, and the description of the procedure
on how to preprocess new data prior to application of the classifier.
}
\section{Slots}{

\describe{
\item{\code{name}}{A character string indicating the name of the classifier}

\item{\code{description}}{A short description of the classifier}

\item{\code{citations}}{A character vector of citations to literature}

\item{\code{normalizationMethod}}{A character string indicating the normalization
method to apply}

\item{\code{eventChain}}{A list of preprocessing steps}

\item{\code{probeNames}}{A character vector}

\item{\code{intercept}}{A numeric value}

\item{\code{weights}}{A numeric vector}

\item{\code{decisionBoundaries}}{A numeric vector with values that separate
the risk-groups}

\item{\code{doRun}}{A function which is called for the actual classification}

\item{\code{means}}{A numeric vector of probe-set means as observed in the
trainingsset (if available)}

\item{\code{sds}}{A numeric vector of probe-set standard deviations as observed
in the trainingsset (if available)}

\item{\code{.geneClassifierVersion}}{An object of class \code{\link{package_version}}}
}}

