% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneAttribution.R
\name{loadBed}
\alias{loadBed}
\title{Load UCSC *.BED files containing empirical data}
\usage{
loadBed(files, weights)
}
\arguments{
\item{files}{A character vector containing *.BED file names}

\item{weights}{An integer vector containing weighting for each bed file. Optional}
}
\value{
A list of GenomicRanges objects containing the data from the *.BED files, with weightings in the score column
}
\description{
Required *.BED file format (tab-separated): chr start end name (optional column: score).
Sample files supplied with package are limited to chromosome 2.
}
\examples{
fileName1 <- system.file("extdata", "hiCRegions.b38.bed", package="geneAttribution")
fileName2 <- system.file("extdata", "eqtlHaplotypeBlocks.b38.bed", package="geneAttribution")
loadBed(c(fileName1, fileName2), c(2, 5))
}

