% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processors.R
\name{processDatasets}
\alias{processDatasets}
\title{Processes JSON as a vector of datasets}
\usage{
processDatasets(d)
}
\arguments{
\item{d}{The JSON to process}
}
\value{
A data table with information about the queried dataset(s). A list if
\code{raw = TRUE}. Returns an empty list if no datasets matched.

The fields of the output data.table are:

\itemize{
\item \code{experiment.shortName}: Shortname given to the dataset within Gemma. Often corresponds to accession ID
\item \code{experiment.name}: Full title of the dataset
\item \code{experiment.ID}: Internal ID of the dataset.
\item \code{experiment.description}: Description of the dataset
\item \code{experiment.troubled}: Did an automatic process within gemma or a curator mark the dataset as "troubled"
\item \code{experiment.accession}: Accession ID of the dataset in the external database it was taken from
\item \code{experiment.database}: The name of the database where the dataset was taken from
\item \code{experiment.URI}: URI of the original database
\item \code{experiment.sampleCount}: Number of samples in the dataset
\item \code{experiment.batchEffectText}: A text field describing whether the dataset has batch effects
\item \code{experiment.batchCorrected}: Whether batch correction has been performed on the dataset.
\item \code{experiment.batchConfound}: 0 if batch info isn't available, -1 if batch counfoud is detected, 1 if batch information is available and no batch confound found
\item \code{experiment.batchEffect}: -1 if batch p value < 0.0001, 1 if batch p value > 0.1, 0 if otherwise and when there is no batch information is available or when the data is confounded with batches.
\item \code{experiment.rawData}: -1 if no raw data available, 1 if raw data was available. When available, Gemma reprocesses raw data to get expression values and batches
\item \code{geeq.qScore}: Data quality score given to the dataset by Gemma.
\item \code{geeq.sScore}: Suitability score given to the dataset by Gemma. Refers to factors like batches, platforms and other aspects of experimental design
\item \code{taxon.name}: Name of the species
\item \code{taxon.scientific}: Scientific name for the taxon
\item \code{taxon.ID}: Internal identifier given to the species by Gemma
\item \code{taxon.NCBI}: NCBI ID of the taxon
\item \code{taxon.database.name}: Underlying database used in Gemma for the taxon
\item \code{taxon.database.ID}: ID of the underyling database used in Gemma for the taxon
}
}
\description{
Processes JSON as a vector of datasets
}
\keyword{internal}
