% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_score.R
\name{gemini_score}
\alias{gemini_score}
\title{Scoring Combination Effect}
\usage{
gemini_score(
  Model,
  pc_gene = NA,
  pc_threshold = NULL,
  pc_weight = 0.5,
  nc_pairs = NA
)
}
\arguments{
\item{Model}{an object of class gemini.model}

\item{pc_gene}{a character vector of any length naming genes to use as positive controls}

\item{pc_threshold}{a numeric value to indicate the LFC corresponding to a positive control, if no pc_gene is specified.}

\item{pc_weight}{a weighting applied to the positive control
(\code{pc_gene}) to filter genes whose individual phenotype is
more lethal than \eqn{pc_weight*y(pc_gene)}.}

\item{nc_pairs}{a set of non-interacting gene pairs to define
statistical significance.}
}
\value{
An object of class gemini.score containing score values for
strong interactions and sensitive lethality and recovery, and if \code{nc_pairs} is specified, statistical significance for each scoring type.
}
\description{
Score genetic interactions from a gemini.model and produce a gemini.score object, and generate p-values and FDRs if negative control
pairs (\code{nc_pairs}) are available.
}
\examples{
data("Model", package = "gemini")
Score <- gemini_score(Model, pc_gene = "EEF2")
}
