\name{plot.GeNetClassifierReturn}
\alias{plotGeNetClassifierReturn}
\alias{plotGeNetClassifierReturn,GeNetClassifierReturn-method}
\alias{plot,GeNetClassifierReturn-method}
\alias{plot.GeNetClassifierReturn}

\title{
Plot GeNetClassifierReturn
}
\description{
Allows generating the plots from the objet created by \code{\link[geNetClassifier:geNetClassifier]{geNetClassifier}}. 
}
\usage{
\method{plot}{GeNetClassifierReturn}(x, y="missing", fileName = NULL, lpThreshold = 0.95, 
    numGenesLpPlot = 1000, numGenesNetworkPlot = 100, 
    geneLabels = NULL, verbose = TRUE, ...)
}
\arguments{
  \item{x}{
GeNetClassifierReturn. Object returned by the main function "\code{\link[geNetClassifier:geNetClassifier]{geNetClassifier}}".
}
  \item{fileName}{
Character. File name to save the plots. 
}
  \item{lpThreshold}{
Numeric between 0 and 1. Required posterior probability value to consider a gene 'significant'.
}
  \item{numGenesLpPlot}{
Integer. Number of genes to show in the significant genes plot.
}
  \item{numGenesNetworkPlot}{
Integer. Number of genes (nodes) to plot in the network.
}
  \item{geneLabels}{
Vector or Matrix. Gene name, ID or label which should be shown in the returned results and plots.
}
  \item{verbose}{
Logical. If TRUE, messages indicating the execution progress will be printed on screen.
}
  \item{y}{Not required.}
  \item{...}{Not required}
}
\details{
The plots are generated by default by \code{\link[geNetClassifier:geNetClassifier]{geNetClassifier}}. This function allows re-plotting them with different parameters.
}
\value{
Plots (depending on the available info):\cr
- \link[geNetClassifier:plot.GenesRanking]{Significant genes}\cr
- \link[geNetClassifier:plotDiscriminantPower]{Classification genes' Discriminant Power}\cr
- \link[geNetClassifier:plotNetwork]{Top ranked genes network (for each class)}\cr
}
\seealso{
Main package function and classifier training: \code{\link[geNetClassifier:geNetClassifier]{geNetClassifier}}\cr
Class \code{\link[geNetClassifier:GeNetClassifierReturn-class]{GeNetClassifierReturn}} \cr
Other plotting functions: \cr
- \code{\link[geNetClassifier:plotDiscriminantPower]{plotDiscriminantPower}}\cr
- \code{\link[geNetClassifier:plot.GenesRanking]{plot.GenesRanking}}\cr
- \code{\link[geNetClassifier:plotNetwork]{plotNetwork}}\cr
}
\examples{


# Train or load an already trained classifier
data(leukemiasClassifier)

# Plot default plots on-screen 
plot(leukemiasClassifier)

# Save plots on file 
# (includes Discriminant Power of all genes, but the networks will not be interactive)
plot(leukemiasClassifier, fileName="newPlots")
}
\keyword{classif }
