% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVenn.R
\name{plotVenn}
\alias{plotVenn}
\title{Plot a Venn Diagram from Genomic or Set Overlap Results}
\usage{
plotVenn(
  overlap_object,
  fills = TRUE,
  edges = TRUE,
  labels = FALSE,
  quantities = list(type = "counts"),
  legend = "right",
  main = NULL,
  ...
)
}
\arguments{
\item{overlap_object}{A \code{GenomicOverlapsResult} or \code{SetOverlapsResult} object
returned by \code{\link{computeOverlaps}}.}

\item{fills}{Controls the fill appearance of the diagram. Can be:
\itemize{
\item \strong{logical}: \code{TRUE} (default) shows fills, \code{FALSE} hides them
\item \strong{character vector}: Colors for the fills.
Default colors are: c("#2B70AB", "#FFB027", "#3EA742", "#CD3301", "#9370DB", "#008B8B", "#D87093")
\item \strong{list}: Fine control with graphical parameters including
\code{fill} (colors), \code{alpha} (transparency 0-1)
}}

\item{edges}{Controls the edge/border appearance. Can be:
\itemize{
\item \strong{logical}: \code{TRUE} (default) shows edges, \code{FALSE} hides them
\item \strong{character vector}: Colors for the edges
\item \strong{list}: Fine control with \code{col} (colors), \code{alpha} (transparency 0-1),
\code{lty} (line type), \code{lwd} (line width), \code{lex} (line expansion)
}}

\item{labels}{Controls set labels. Can be:
\itemize{
\item \strong{logical}: \code{TRUE} shows default labels, \code{FALSE} hides them
\item \strong{character vector}: Custom text for labels
\item \strong{list}: Fine control with \code{col} (text color), \code{fontsize},
\code{font} (1=plain, 2=bold, 3=italic, 4=bold italic), \code{fontfamily},
\code{cex} (character expansion), \code{alpha} (transparency 0-1)
}}

\item{quantities}{Controls intersection quantities display. Can be:
\itemize{
\item \strong{logical}: \code{TRUE} shows counts, \code{FALSE} hides them
\item \strong{character vector}: Custom text labels
\item \strong{list}: Fine control with \code{type} (c("counts", "percent")),
\code{col} (text color), \code{fontsize}, \code{font}, \code{fontfamily}, \code{cex}, \code{alpha}
}}

\item{legend}{Controls the legend. Can be:
\itemize{
\item \strong{logical}: \code{FALSE} to disable
\item \strong{character}: Position ("right", "top", "bottom", "left")
\item \strong{list}: Fine control with \code{side} (position), \code{labels}
(custom labels), \code{col}, \code{fontsize}, \code{cex}, \code{fontfamily}
}}

\item{main}{Title for the plot. Can be character, expression, or list with
\code{label} (text), \code{col}, \code{fontsize}, \code{font}, \code{fontfamily}}

\item{...}{Additional arguments passed to \code{\link[eulerr]{plot.euler}}.}
}
\value{
A Venn diagram plot generated by \code{eulerr}.
}
\description{
This function creates a Venn diagram using the \code{eulerr} package to visualize
intersections across multiple sets. Supports both
\code{GenomicOverlapsResult} and \code{SetOverlapsResult} objects.
}
\examples{
# Example with gene sets
data(gene_list)
res_sets <- computeOverlaps(gene_list)

# Basic plot
plotVenn(res_sets)

# Customize fills with transparency and custom colors
plotVenn(res_sets,
         fills = list(fill = c("#FF6B6B", "#4ECDC4", "#45B7D1"),
                      alpha = 0.6))

# Customize edges
plotVenn(res_sets,
         edges = list(col = "darkgray", lwd = 2, lty = 2))

# Customize labels
plotVenn(res_sets,
         labels = list(col = "white", font = 2, fontsize = 14))

# Show both counts and percentages
plotVenn(res_sets,
         quantities = list(type = c("counts", "percent"),
                          col = "black", fontsize = 10))

# Add a title
plotVenn(res_sets,
         main = list(label = "Gene Set Overlaps",
                     col = "navy", fontsize = 16, font = 2))

# Transparent fills with colored borders only
plotVenn(res_sets,
         fills = "transparent",
         edges = list(col = c("red", "blue", "green"), lwd = 3))

# Custom legend
plotVenn(res_sets,
         legend = list(side = "bottom",
                      labels = c("Treatment A", "Treatment B", "Control"),
                      fontsize = 12))
}
