% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiomics.R
\name{run_multiomics}
\alias{run_multiomics}
\title{Complete Multi-Omics integration}
\usage{
run_multiomics(
  data,
  interactions_met = NULL,
  interactions_miRNA_target = NULL,
  interactions_tf = NULL,
  interactions_tf_miRNA = NULL,
  RNAseq = TRUE,
  miRNAseq = TRUE,
  normalize_miRNA_expr = TRUE,
  normalize_gene_expr = TRUE,
  norm_method_gene_expr = "TMM",
  norm_method_miRNA_expr = "TMM",
  class = NULL,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{data}{A MultiAssayExperiment. It can be generated exploiting the
\strong{generate_multiassay} function.}

\item{interactions_met}{\strong{interactions} as for \strong{run_met_integration}}

\item{interactions_miRNA_target}{miRNA-target interactions as requested by
\strong{run_tf_integration}}

\item{interactions_tf}{TF-target interactions as requested by
\strong{run_tf_integration}}

\item{interactions_tf_miRNA}{TF-target interactions as
requested by \strong{run_tf_integration}}

\item{RNAseq}{logical. Are gene expression data obtained from RNA
sequencing ? Default is set to TRUE}

\item{miRNAseq}{logical. Are miRNA expression data obtained from miRNA
sequencing ? Default is set to TRUE}

\item{normalize_miRNA_expr}{logical.Should miRNA expression data be
normalized ? Default is set to TRUE}

\item{normalize_gene_expr}{logical.Should gene expression data be
normalized ? Default is set to TRUE}

\item{norm_method_gene_expr}{Normalization method to be used for gene
expression data. One of "TMM" (default), "TMMwsp", "RLE", "upperquartile",
"none".}

\item{norm_method_miRNA_expr}{Normalization method to be used for miRNA
expression data. One of "TMM" (default), "TMMwsp", "RLE", "upperquartile",
"none".}

\item{class}{Character vector specifying the classes for differential
expression analysis.}

\item{BPPARAM}{A BiocParallelParam object specifying the parallel backend to
be used.}
}
\value{
A \linkS4class{MultiOmics} object containing the results of all the
possible integration models
}
\description{
This function will perform a complete Multi-Omics integration on a
MultiAssayExperiment
}
\examples{
# Example usage_multiomics:
library(MultiAssayExperiment)
data("mmultiassay_ov")
tmp <- lapply(experiments(mmultiassay_ov), function(x) x[1:20,])
mmultiassay_ov <- MultiAssayExperiment(experiments = tmp)
multiomics_integration <- run_multiomics(data = mmultiassay_ov)
}
