% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_volcano}
\alias{plot_volcano}
\title{plotting volcano}
\usage{
plot_volcano(data_table, omics = NULL, cnv_met = NULL)
}
\arguments{
\item{data_table}{The data table containing information for the volcano plot.}

\item{omics}{Optional. The omics type for the volcano plot.}

\item{cnv_met}{Optional. Indicates whether the volcano plot is for CNV or
MET omics (only applicable if omics is specified).}
}
\value{
A volcano plot.
}
\description{
plotting volcano
}
\examples{
# Example usage:
library(MultiAssayExperiment)
data("mmultiassay_ov")
tmp <- lapply(experiments(mmultiassay_ov), function(x) x[1:20,])
mmultiassay_ov <- MultiAssayExperiment(experiments = tmp)
multiomics_integration <- run_multiomics(data = mmultiassay_ov)
data_table <- extract_model_res(multiomics_integration)
plot_volcano(data_table, omics = "gene_genomic_res", cnv_met = "cnv")
}
