% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_ridge}
\alias{plot_ridge}
\title{plotting ridge}
\usage{
plot_ridge(data_table, omics = NULL, cnv_met = NULL)
}
\arguments{
\item{data_table}{The data table containing information for the ridge plot.}

\item{omics}{Optional. The omics type for the ridge plot.}

\item{cnv_met}{Optional. Indicates whether the ridge plot is for CNV or MET
omics (only applicable if omics is specified).}
}
\value{
A ridge plot.
}
\description{
plotting ridge
}
\examples{
# Example usage:
library(MultiAssayExperiment)
data("mmultiassay_ov")
tmp <- lapply(experiments(mmultiassay_ov), function(x) x[1:20,])
mmultiassay_ov <- MultiAssayExperiment(experiments = tmp)
gene_cnv_matrix <- t(as.matrix(assay(mmultiassay_ov[["cnv_data"]])))
gene_exp_matrix <- t(as.matrix(assay(mmultiassay_ov[["gene_exp"]])))
cnv_integration <- run_cnv_integration(
    expression = gene_exp_matrix,
    cnv_data = gene_cnv_matrix
)
data_table <- extract_model_res(cnv_integration)
data_table <- data_table[data_table$cov!="(Intercept)",]
plot_ridge(data_table)
}
