% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_MAE.R
\name{standardize_mae}
\alias{standardize_mae}
\title{Standardize MAE by switching from custom identifiers into gDR-default}
\usage{
standardize_mae(mae, use_default = TRUE)
}
\arguments{
\item{mae}{a MultiAssayExperiment object with drug-response data generate by gDR pipeline}

\item{use_default}{boolean indicating whether or not to use default
identifiers for standardization}
}
\value{
mae a MultiAssayExperiment with default gDR identifiers
}
\description{
Standardize MAE by switching from custom identifiers into gDR-default
}
\examples{
mae <- get_synthetic_data("finalMAE_small.qs")
S4Vectors::metadata(mae[[1]])$identifiers$drug <- "druug"
standardize_mae(mae)

}
\keyword{standardize_MAE}
