% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize_MAE.R
\name{set_unique_names_dt}
\alias{set_unique_names_dt}
\title{Set unique primary identifiers in the data.frame-like objects}
\usage{
set_unique_names_dt(dt, primary_name, secondary_name, sep = " ")
}
\arguments{
\item{dt}{data.table, data.frame or DFrame with data}

\item{primary_name}{string with the name of the primary field}

\item{secondary_name}{string with the name of the secondary field}

\item{sep}{string with separator added before suffix}
}
\value{
fixed input table with unique primary field in the table
}
\description{
This function sets the primary field in the data.frame-like objects to be unique
by appending the secondary field in parentheses for duplicates.
}
\examples{
col_data <- S4Vectors::DataFrame(CellLineName = c("ID1", "ID1"), clid = c("C1", "C2"))
col_data <- set_unique_names_dt(col_data, primary_name = "CellLineName", secondary_name = "clid")
}
\keyword{standardize_MAE}
