% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{remove_codrug_data}
\alias{remove_codrug_data}
\title{Remove Codrug Data}
\usage{
remove_codrug_data(
  data,
  prettify_identifiers = TRUE,
  codrug_identifiers = c("drug_name2", "concentration2")
)
}
\arguments{
\item{data}{data.table with input data}

\item{prettify_identifiers}{logical flag specifying if identifiers are expected to be prettified}

\item{codrug_identifiers}{character vector with identifiers for the codrug columns}
}
\value{
data.table without combination columns
}
\description{
Remove Codrug Data
}
\examples{

dt <-
  data.table::data.table(
    "Drug Name" = letters[seq_len(3)],
    "Concentration" = seq_len(3),
    "Drug Name 2" = letters[4:6],
    "Concentration 2" = 4:6
  )
dt
remove_codrug_data(dt)

}
\keyword{combination_data}
