% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_to_bm_assay.R
\name{df_to_bm_assay}
\alias{df_to_bm_assay}
\title{df_to_bm_assay}
\usage{
df_to_bm_assay(data, discard_keys = NULL)
}
\arguments{
\item{data}{data.table with drug-response data}

\item{discard_keys}{a vector of keys that should be discarded}
}
\value{
BumpyMatrix object
}
\description{
Convert data.table with dose-response data into a BumpyMatrix assay.
}
\details{
The 'assay' is simply a BumpyMatrix object with rownames being the treatment ids,
colnames being the ids of the cell lines and values with
dose-response data for given cell lines under given conditions.
}
\examples{
df_to_bm_assay(data.table::data.table(Gnumber = 2, clid = "A"))

}
\keyword{convert}
