% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinations-helpers.R
\name{replace_conc_with_standardized_conc}
\alias{replace_conc_with_standardized_conc}
\title{Standardize concentrations.}
\usage{
replace_conc_with_standardized_conc(
  original_concs,
  conc_map,
  original_conc_col,
  standardized_conc_col
)
}
\arguments{
\item{original_concs}{numeric vector of concentrations to replace
using \code{conc_map}.}

\item{conc_map}{data.table of two columns named \code{original_conc_col}
and \code{standardized_conc_col}.}

\item{original_conc_col}{string of the name of the column in \code{conc_map}
containing the original concentrations to replace.}

\item{standardized_conc_col}{string of the name of the column
in \code{conc_map} containing the standardized
concentrations to use for replacement.}
}
\value{
numeric vector of standardized concentrations.
}
\description{
Utilize a map to standardize concentrations.
}
\examples{
conc_map <- data.table::data.table(
  orig = c(0.99, 0.6, 0.456, 0.4), 
  std = c(1, 0.6, 0.46, 0.4)
)
original_concs <- c(0.456, 0.456, 0.4, 0.99)
exp <- c(0.46, 0.46, 0.4, 1)
obs <- replace_conc_with_standardized_conc(
  original_concs, 
  conc_map,
  original_conc_col = "orig", 
  standardized_conc_col = "std"
)
}
\seealso{
map_conc_to_standardized_conc
}
\keyword{utils}
