% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_input.R
\name{prepare_input}
\alias{prepare_input}
\title{Prepare input data common for all experiments}
\usage{
prepare_input(x, ...)
}
\arguments{
\item{x}{data.table with raw data or MAE object with dose-response data}

\item{...}{additional parameters}
}
\value{
list of input data
}
\description{
Current steps
\itemize{
\item refining nested confounders
\item refining nested identifiers
\item splitting df_ into (per experiment) df_list
}
}
\examples{
td <- gDRimport::get_test_data()
l_tbl <- gDRimport::load_data(
  manifest_file = gDRimport::manifest_path(td), 
  df_template_files = gDRimport::template_path(td), 
  results_file = gDRimport::result_path(td)
)
df_ <- merge_data(
  l_tbl$manifest, 
  l_tbl$treatments, 
  l_tbl$data
)
nested_confounders = intersect(
  names(df_), 
  gDRutils::get_env_identifiers("barcode")
)
prepare_input(df_, nested_confounders, NULL)

}
\keyword{prepare_input}
