% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileutilities.R
\name{ct.simpleResult}
\alias{ct.simpleResult}
\title{Convert a verbose results DF object to a gene-level result object}
\usage{
ct.simpleResult(summaryDF, collapse = c("geneSymbol", "geneID"))
}
\arguments{
\item{summaryDF}{A \code{data.frame}, usually returned by \code{ct.generateResults}. 
if you need to generate one of these by hand for some reason, see the example 
\code{resultsDF} object loaded in the example below.}

\item{collapse}{Column of the provided resultsDF on which to collapse values; in most cases this should be 
`geneSymbol` or `geneID`.}
}
\value{
A gene-level `data.frame`, with guide-level information omitted
}
\description{
Convenience function to reduce a full results object to a gene-level object 
that retains minimal statistics (or alternatively, check that a provided simple result object is valid).
}
\examples{
data('resultsDF')
ct.simpleResult(resultsDF)
}
\author{
Russell Bainer
}
