% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalization.R
\name{ct.normalizeBySlope}
\alias{ct.normalizeBySlope}
\title{Normalize sample abundance estimates by the slope of the values in the central range}
\usage{
ct.normalizeBySlope(ExpressionObject, trim = 0.25, lib.size = NULL, ...)
}
\arguments{
\item{ExpressionObject}{An ExpressionSet containing, at minimum, count data accessible by \code{exprs}, or an EList object with count data in the $E 
slot (usually returned by \link[limma]{voom}).}

\item{trim}{The proportion to be trimmed from each end of the distributionbefore performing the linear fit; algorithm defaults to 25% such that the
fit is performed on the interquartile range.}

\item{lib.size}{An optional vector of size factor adjusted library size. 
Default: \code{NULL} means to use sum of column counts as a lib.size.}

\item{...}{Other arguments to be passed to \code{ct.normalizeMedians()}, if desired.}
}
\value{
A renormalized object of the same type as the provided object.
}
\description{
This function normalizes Crispr gRNA abundance estimates by equalizing the slopes of the middle (logged) values of the
distribution across samples. Specifically, the algorithm ranks the gRNA abundance estimates within each sample and determines a relationship between
rank change and gRNA within a trimmed region of the distribution via a linear fit. It then adjusts each sample such that the center of the logged
abundance distribution is strictly horizontal and returns these values as median-scaled counts in the appropriate slot of the input ExpressionObject.
}
\examples{
data('es')
data('ann')

#Build the sample key and library sizes for visualization
library(Biobase)
sk <- ordered(relevel(as.factor(pData(es)$TREATMENT_NAME), 'ControlReference'))
names(sk) <- row.names(pData(es))
ls <- colSums(exprs(es))

es.norm <- ct.normalizeBySlope(es, lib.size= ls)
ct.gRNARankByReplicate(es, sk, lib.size= ls)
ct.gRNARankByReplicate(es.norm, sk, lib.size= ls)
}
\author{
Russell Bainer
}
