% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateReports.R
\name{ct.makeContrastReport}
\alias{ct.makeContrastReport}
\title{Generate a Contrast report from a pooled CRISPR screen}
\usage{
ct.makeContrastReport(
  eset,
  fit,
  sampleKey,
  results,
  annotation,
  comparison.id,
  identifier,
  contrast.subset = colnames(eset),
  outdir = NULL
)
}
\arguments{
\item{eset}{An ExpressionSet object containing, at minimum, a matrix of gRNA
abundances extractable with the \code{exprs()} function and some named 
phenodata extractable with \code{pData()}.}

\item{fit}{A fit object for the contrast of interest, usually generated with
\code{lmFit}.}

\item{sampleKey}{A sample key, supplied as an ordered factor linking the 
samples to experimental variables. The \code{names} attribute should 
exactly match those present in \code{eset}, and the control set is assumed
to be the first \code{level}.}

\item{results}{A data.frame summarizing the results of the screen, returned 
by the function \code{\link{ct.generateResults}}.}

\item{annotation}{An annotation object for the experiment. See the man page 
for \code{ct.prepareAnnotation()} for details and example format.}

\item{comparison.id}{character with a name of the comparison.}

\item{identifier}{A character string to name the report and corresponding 
subdirectories. If provided, the final report will be called 
'\code{identifier}.html' and will be located in a directory called 
\code{identifier} in the \code{outdir}. If \code{NULL}, a generic name}

\item{contrast.subset}{character vector containing the sample
labels to be used in the analysis; all elements must be contained in the
\code{colnames} of the specified \code{eset}. including the timestamp will
be generated. Default: \code{colnames(eset)}.}

\item{outdir}{An optional character string indicating the directory in which to 
generate the report. If \code{NULL}, a temporary directory will be automatically 
generated.}
}
\value{
The path to the generated html report.
}
\description{
This is a function to generate an html Contrast report for a 
  CRISPR screen, focusing on contrast-level analyses collected from other 
  functions in \code{gCrisprTools}. It is designed to be used 'as-is', and 
  analysts interested in using different functionalities of the various 
  functions should do that outside of this wrapper script.
}
\examples{
data('es')
data('fit')
data('ann')
data('resultsDF')

##' #Build the sample key
library(Biobase)
sk <- ordered(relevel(as.factor(pData(es)$TREATMENT_NAME), 'ControlReference'))
names(sk) <- row.names(pData(es))

path2report <- ct.makeContrastReport(es, fit, sk, resultsDF, ann, comparison.id = NULL, outdir = '.') 
}
\author{
Russell Bainer, Dariusz Ratman
}
