% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discardTraceReads.R
\name{ct.filterReads}
\alias{ct.filterReads}
\title{Remove low-abundance elements from an ExpressionSet object}
\usage{
ct.filterReads(
  eset,
  trim = 1000,
  log2.ratio = 4,
  sampleKey = NULL,
  plot.it = TRUE,
  read.floor = NULL
)
}
\arguments{
\item{eset}{An unnormalized \code{ExpressionSet} object containing, at minimum, a matrix of gRNA counts accessible with \code{exprs()}.}

\item{trim}{The number of gRNAs to be trimmed from the top of the distribution before estimating the abundance range. Empirically, this usually should be equal to about 2 to 5 percent of the guides in the library.}

\item{log2.ratio}{Maximum abundance of contaminant gRNAs, expressed on the log2 scale from the top of the trimmed range 
of each sample. That is, \code{log2.ratio = 4} means to discard all gRNAs whose abundance is (1/2)^4 of the trimmed maximum.}

\item{sampleKey}{An (optional) sample key, supplied as an ordered factor linking the samples to experimental
variables. The \code{names} attribute should exactly match those present in \code{eset}, and the control set is assumed to be
the first \code{level}.}

\item{plot.it}{Logical value indicating whether to plot the adjusted gRNA densities on the default device.}

\item{read.floor}{Optionally, the minimum number of reads required for each gRNA.}
}
\value{
An \code{ExpressionSet} object, with trace-abundance gRNAs omitted.
}
\description{
This function removes gRNAs only present in very low abundance across all samples of a pooled Crispr
screening experiment. In most cases very low-abundance guides are the
result of low-level contamination from other libraries, and often distort standard normalization approaches. This
function trims gRNAs in a largely heuristic way, assuming that the majority of 'real' gRNAs within the library are
comparably abundant in at least some of the samples (such as unexpanded controls), and that contaminants are
present at negligible levels. Specifically, the function trims the \code{trim}
most abundant guides from the upper tail of each log-transformed sample distribution, and then omits gRNAs whose
abundances are always less than 1/(2^\code{log2.ratio}) of this value.
}
\examples{
data('es')
ct.filterReads(es)
}
\author{
Russell Bainer
}
