% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneratePRC.R
\name{ct.PRC}
\alias{ct.PRC}
\title{Generate a Precision-Recall Curve from a CRISPR screen}
\usage{
ct.PRC(
  summaryDF,
  target.list,
  direction = c("enrich", "deplete"),
  plot.it = TRUE
)
}
\arguments{
\item{summaryDF}{A dataframe summarizing the results of the screen, returned by the function \code{\link{ct.generateResults}}.}

\item{target.list}{A character vector containing the names of the targets to be tested; by default these are assumed to be `geneID`s, 
but specifying `collapse=geneSymbol` enables setting on `geneSymbol` by passing that value through to `ct.simpleResult`.}

\item{direction}{Direction by which to order target signals (`enrich` or `deplete`).}

\item{plot.it}{Logical value indicating whether to plot the curves.}
}
\value{
A list containing the the x and y coordinates of the curve.
}
\description{
Given a set of targets of interest, this function generates a Precision Recall curve from the results of 
a CRISPR screen. Specifically, it orders the target elements in the screen in the specified direction, and then plots the recall 
rate (proportion of true targets identified) against the precision (proportion of identified targets that are true targets). 

Note that ranking statistics in CRISPR screens are (usually) permutation-based, and so some granularity in the rankings is expected. This 
function does a little extra work to ensure that hits are counted as soon as the requisite value of the ranking statistic is reached 
regardless of where the gene is located within the block of equally-significant genes. Functionally, this means that the drawn curve is
somewhat anticonservative in cases where the gene ranks are not well differentiated.
}
\examples{
data('resultsDF')
data('essential.genes') #Note that this is an artificial example.
pr <- ct.PRC(resultsDF, essential.genes, 'enrich')
str(pr)
}
\author{
Russell Bainer
}
