% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparrow_integration.R
\name{ct.GREATdb}
\alias{ct.GREATdb}
\title{Update a gene-centric msdb object for GREAT-style enrichment analysis using a specified CRISPR annotation.}
\usage{
ct.GREATdb(
  annotation,
  gsdb = sparrow::getMSigGeneSetDb(collection = c("h", "c2"), species = "human", id.type
    = "ensembl"),
  minsize = 10,
  ...
)
}
\arguments{
\item{annotation}{an annotation object returned by \code{ct.prepareAnnotation()}.}

\item{gsdb}{A gene-centric \code{GeneSetDb} object to conform to the relevant peakwise dataset.}

\item{minsize}{Minimum number of targets required to consider a geneset valid for analysis.}

\item{...}{Additional arguments to be passed to `ct.prepareAnnotation()`.}
}
\value{
A new \code{GeneSetDb} object with the features annotated genewise to pathways.
}
\description{
Update a gene-centric `GeneSetDb` object for GREAT-style enrichment analysis using a specified annotation.

Often, pooled screening libraries are constructed such that the gene targets of interest are associated 
with variable numbers of semi-independent screen signals (associated with, e.g., sets of alternative promoters 
or cis regulatory units). Such an arrangement is often unavoidable but produces to complications when 
performing gene set enrichent analyses. This function conforms a standard `GeneSetDb` object to appropriately 
consider this form of ultiple testing during ontological enrichment analyses according to the GREAT strategy
outlined by [McLean et al. (2009)](https://doi.org/10.1038/nbt.1630).

Operationally, this means that genewise sets in the provided object will be translated to the corresponding 
`geneSymbol` sets provided in the annotation file.
}
\examples{
data(resultsDF)
data(ann)
gsdb <- ct.GREATdb(ann, gsdb = sparrow::getMSigGeneSetDb(collection = 'h', species = 'human', id.type = 'entrez'))
show(sparrow::featureIds(gsdb))
}
