% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSet.R
\docType{methods}
\name{getSnpM}
\alias{getSnpM}
\alias{getSnpM,SampleSet-method}
\title{Computes M values after normalization of SNP data.}
\usage{
getSnpM(object)

\S4method{getSnpM}{SampleSet}(object)
}
\arguments{
\item{object}{of class SampleSet}
}
\value{
a matrix containing M values, log2(Meth/Unmeth), after normalization
for SNP data
}
\description{
Computes M values after normalization of SNP data.
}
\section{Methods (by class)}{
\itemize{
\item \code{SampleSet}: Computes M values, log2(Meth/Unmeth), for normalized
SNP data
}}

\examples{
require(minfiData)
pData(RGsetEx)$cell_type <- rep(c("type1","type2"),3)
mySampleSet=fromRGChannelSet(RGsetEx)
snp=getSnpM(funtooNorm(mySampleSet))

}
