% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{summarize_pathway_level}
\alias{summarize_pathway_level}
\title{Aggregates or summarizes omics data into higher-level functional representations that can be interpreted as functional activity scores or measures.}
\usage{
summarize_pathway_level(omicsmat, sets = NULL, type = "mean", minsize = 10)
}
\arguments{
\item{omicsmat}{A matrix or data frame representing omics data. Rows correspond to molecular identifiers, and columns correspond to samples.}

\item{sets}{A list of functional sets. Each element in the list should represent a molecular set, and the elements of the set should match the row names of the omics matrix.}

\item{type}{The type of pooling operator to be applied for each set. Possible values include "mean" (default), "median", "sd", "min", "max", "pca", "mds", "pathifier", "nmf", "ttest", "wilcox", "kolmogorov".}

\item{minsize}{The minimum size per molecular set (default is 10).}
}
\value{
A matrix-like table with the activity measures for each group or set of molecules, i.e., sxn matrix,
for s molecular sets and n samples.
}
\description{
Given an omics matrix and a list of functional molecular sets, this function aggregates or summarizes
the omics data into higher-level functional representations such as GO terms gene sets or KEGG metabolic pathways, facilitating the analysis
of functional molecular sets that allow reducing dimensionality and providing
easier and faster biological interpretations. Coordinated functional activity scores
can be as informative as single molecules.
}
\details{
Notes:

- Different aggregation operators can be used, including summary statistics such as median (default), mean, sd, min, max,
dimensionality reduction scores such as pca, mds, pathifier, or nmf, and statistical tests such as ttest, wilcoxon test, kolmogorov test.

- The minimum size per molecular set is by default 10 molecules (e.g. genes or metabolites) and can be changed with the parameter minsize.

- If "pathifier" is chosen as pooling type, the `aggby_pathifier` function internally generates a log file named 'pathifierlog.txt' during its execution.

This log file may contain additional information that could be useful for troubleshooting or advanced analysis.

Users typically do not need to interact with this file directly, but it is mentioned here for informational purposes. For more details, this
function utilizes the \href{https://bioconductor.org/packages/pathifier/}{Pathifier} package.
}
\examples{
# Example usage:
g <- 10000
s <- 20
X <- matrix(abs(rnorm(g * s)), nrow = g, dimnames = list(paste0("g", 1:g), paste0("s", 1:s)))
pathways <- as.list(sample(10:100, size = 100, replace = TRUE))
pathways <- lapply(pathways, function(s, g) paste0("g", sample(1:g, size = s, replace = FALSE)), g)
names(pathways) <- paste0("pathway", seq_along(pathways))
pathway_activity <- summarize_pathway_level(X, pathways, type = "mean", minsize = 12)
}
\author{
Elisa Gomez de Lope
}
\keyword{activity-scores}
\keyword{aggregation}
\keyword{functional}
\keyword{omics}
\keyword{pathway}
\keyword{representation}
\keyword{summary}
