% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fobi_graph.R
\name{fobi_graph}
\alias{fobi_graph}
\title{Generate FOBI Graphs}
\usage{
fobi_graph(
  terms = NULL,
  get = NULL,
  property = c("is_a", "BiomarkerOf", "Contains"),
  layout = "sugiyama",
  labels = FALSE,
  labelsize = 3,
  legend = FALSE,
  legendSize = 10,
  legendPos = "bottom",
  curved = FALSE,
  pointSize = 3,
  fobi = fobitools::fobi
)
}
\arguments{
\item{terms}{A character vector with FOBI term IDs.}

\item{get}{A character string indicating desired relationships between provided terms. Options are 'anc' (for ancestors) and 'des' (for descendants). Default is NULL and all information related with input terms will be provided.}

\item{property}{A character vector indicating which properties should be plotted. Options are 'is_a', 'BiomarkerOf', and 'Contains'. By default all of them are included.}

\item{layout}{A character string indicating the type of layout to create. Options are 'sugiyama' (default) and 'lgl'.}

\item{labels}{Logical indicating if node names should be plotted or not.}

\item{labelsize}{Numeric value indicating the size of labels.}

\item{legend}{Logical indicating if legend should be plotted or not.}

\item{legendSize}{Numeric value indicating the size of legend.}

\item{legendPos}{A character string indicating the legend position (if legend parameter is set to TRUE). Options are 'bottom' (default) and 'top'.}

\item{curved}{Logical indicating if the shape of the edges shape should be curved or not.}

\item{pointSize}{Numeric value indicating the size of graph points.}

\item{fobi}{FOBI table obtained with `parse_fobi()`. If this value is set to NULL, the last version of FOBI will be downloaded from GitHub.}
}
\value{
A ggraph object.
}
\description{
This function allows users to create networks based on FOBI relationships.
}
\examples{

terms <- c("CHEBI:16164","CHEBI:16243","FOODON:00001139","FOODON:00003274","FOODON:00003275")
fobi_graph(terms, get = "anc")

# Red meat related FOBI biomarkers
fobi_graph(terms = "FOBI:0193", 
           property = c("is_a", "BiomarkerOf"), 
           layout = "lgl", curved = TRUE) # set labels = TRUE to display node names

}
\references{
Pol Castellano-Escuder, Raúl González-Domínguez, David S Wishart, Cristina Andrés-Lacueva, Alex Sánchez-Pla, FOBI: an ontology to represent food intake data and associate it with metabolomic data, Database, Volume 2020, 2020, baaa033, https://doi.org/10.1093/databa/baaa033.
}
\author{
Pol Castellano-Escuder
}
