% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ora.R
\name{ora}
\alias{ora}
\title{Classical Over Representation Analysis with FOBI}
\usage{
ora(
  metaboliteList,
  metaboliteUniverse,
  subOntology = "food",
  pvalCutoff = 0.01,
  fobi = fobitools::fobi
)
}
\arguments{
\item{metaboliteList}{A vector of FOBI metabolite identifiers that define the selected list of metabolites.}

\item{metaboliteUniverse}{A vector of FOBI metabolite identifiers that define the universe of possible metabolites (all metabolites analyzed in the study).}

\item{subOntology}{A character string specifying one of the two FOBI sub-ontologies: "food", or "biomarker".}

\item{pvalCutoff}{A numeric value indicating a p-value cutoff for raw p-values generated by hypergeometric test.}

\item{fobi}{FOBI table obtained with `parse_fobi()`. If this value is set to NULL, the last version of FOBI will be downloaded from GitHub.}
}
\value{
A tibble with ORA results.
}
\description{
This function performs a traditional over representation analysis based on hypergeometric test: classes are treated as sets of individual metabolites and all metabolites are treated as equally informative. This function uses Food-Biomarker Ontology knowledge as biological information.
}
\examples{

metaboliteUniverse <- c(fobitools::idmap$FOBI[1:200], fobitools::idmap$FOBI[400:450])
metaboliteList <- c(fobitools::idmap$FOBI[1:50], fobitools::idmap$FOBI[70:80])

# Food enrichment analysis
fobitools::ora(metaboliteList = metaboliteList, 
               metaboliteUniverse = metaboliteUniverse, 
               pvalCutoff = 1)

# Chemical class enrichment analysis
fobitools::ora(metaboliteList = metaboliteList, 
               metaboliteUniverse = metaboliteUniverse, 
               subOntology = "biomarker", 
               pvalCutoff = 1)

}
\references{
G. Korotkevich, V. Sukhov, A. Sergushichev. Fast gene set enrichment analysis. bioRxiv (2019), doi:10.1101/060012

Pol Castellano-Escuder, Raúl González-Domínguez, David S Wishart, Cristina Andrés-Lacueva, Alex Sánchez-Pla, FOBI: an ontology to represent food intake data and associate it with metabolomic data, Database, Volume 2020, 2020, baaa033, https://doi.org/10.1093/databa/baaa033.
}
\author{
Pol Castellano-Escuder
}
