% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{summary}
\alias{summary}
\alias{summary,fmrsfit-method}
\alias{summary,summary-method}
\alias{summary,fmrstunpar-method}
\title{summary method}
\usage{
summary(object, ...)

summary(object, ...)

\S4method{summary}{fmrsfit}(object, ...)

\S4method{summary}{fmrstunpar}(object, ...)
}
\arguments{
\item{object}{An \code{\link{fmrsfit-class}} or
\code{\link{fmrstunpar-class}}}

\item{...}{Other possible arguments}
}
\value{
Summary of the fitted \code{FMRs} model

Summary of the selected component-wise tuning parameters
}
\description{
Displays the fitted \code{FMRs} model by showing the estimated
coefficients, dispersions and mixing proportions

Display the selected component-wise tuning parameters
}
\examples{
set.seed(1980)
K = 2
D = 10
n = 500
sig = c(1, 1)
piM = c(0.4, 0.6)
r1 = 0.5
coeff1 = c( 2,  2, -1, -2, 1, 2, 0, 0,  0, 0,  0)
coeff2 = c(-1, -1,  1,  2, 0, 0, 0, 0, -1, 2, -2)
Um = 40

dat <- fmrs.gendata(nObs = n, nComp = K, nCov = D, coeff = c(coeff1, coeff2),
dispersion = sig, mixProp = piM, rho = r1, umax = Um, disFamily = 'lnorm')

res.mle <- fmrs.mle(y = dat$y, x = dat$x, delta = dat$delta, nComp = K,
disFamily = 'lnorm', initCoeff = rnorm(K*D+K), initDispersion = rep(1, K),
initmixProp = rep(1/K, K))

summary(res.mle)
res.lam <- fmrs.tunsel(y = dat$y, x = dat$x, delta = dat$delta,
nComp = K, disFamily = 'lnorm', initCoeff = c(coefficients(res.mle)),
initDispersion = dispersion(res.mle), initmixProp = mixProp(res.mle),
penFamily = 'adplasso')

summary(res.lam)
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
