% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{preprocess.Frames}
\alias{preprocess.Frames}
\title{Preprocessing function for \code{Frames} objects}
\usage{
preprocess.Frames(
  frames,
  brush.size = 3,
  brush.shape = "disc",
  at.offset = 0.15,
  at.wwidth = 10,
  at.wheight = 10,
  kern.size = 3,
  kern.shape = "disc",
  ws.tolerance = 1,
  ws.radius = 1,
  displayprocessing = FALSE,
  ...
)
}
\arguments{
\item{frames}{A \code{Frames} object}

\item{brush.size}{Size in pixels of the brush to be used for initial smoothing
(low-pass filtering)}

\item{brush.shape}{Shape of the brush to be used for initial smoothing (low-pass
filtering)}

\item{at.offset}{Offset to be used in the adaptive thresholding step - see also \code{\link[EBImage:thresh]{EBImage::thresh()}}. As an
alternative thresholding method, see also \code{\link[EBImage:otsu]{EBImage::otsu()}} in the \code{EBImage} package.}

\item{at.wwidth}{Width of the window for the adaptive thresholding step - see also \code{\link[EBImage:thresh]{EBImage::thresh()}}. As an
alternative thresholding method, see also \code{\link[EBImage:otsu]{EBImage::otsu()}} in the \code{EBImage} package.}

\item{at.wheight}{Height of the window for the adaptive thresholding step - see also \code{\link[EBImage:thresh]{EBImage::thresh()}}. As an
alternative thresholding method, see also \code{\link[EBImage:otsu]{EBImage::otsu()}} in the \code{EBImage} package.}

\item{kern.size}{Size in pixels of the kernel used for morphological operations - e.g., opening, which is an erosion followed by a dilation, and closing which is a dilation followed by an erosion - see also \code{\link[EBImage:morphology]{EBImage::opening()}}, \code{\link[EBImage:morphology]{EBImage::closing()}}}

\item{kern.shape}{Shape of the kernel used for morphological operations}

\item{ws.tolerance}{Tolerance allowed in performing the watershed-based segmentation (see also \code{\link[EBImage:watershed]{EBImage::watershed()}})}

\item{ws.radius}{Radius for the watershed-based segmentation (see also \code{\link[EBImage:watershed]{EBImage::watershed()}})}

\item{displayprocessing}{Logical, whether to display intermediate steps while performing preprocessing. Dismissed currently, it could increase runtime a lot}

\item{...}{Arguments to be passed to methods}
}
\value{
A \code{Frames} object, whose frame images are the preprocessed versions of the input images
}
\description{
\code{Frames} objects are processed according to the chosen set of parameters. Many of them refer directly to
existing \code{EBImage} functions, please see the corresponding help for additional information
}
\examples{
data("MesenteriumSubset")
preprocess.Frames(channel.Frames(MesenteriumSubset,"red"))

}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
