% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{particles}
\alias{particles}
\title{Extracts particles from the images of a \code{Frames} object.}
\usage{
particles(
  raw.frames,
  binary.frames = NULL,
  channel = NULL,
  BPPARAM = bpparam()
)
}
\arguments{
\item{raw.frames}{A \code{Frames} object with the raw images (mandatory)}

\item{binary.frames}{A \code{Frames} object with preprocessed images (optional, if not provided gets produced with standard default parameters)}

\item{channel}{Character string. The channel to perform the operations on. Can be \code{red}, \code{green} or \code{blue}}

\item{BPPARAM}{a \code{MulticoreParam} object, used to control the performances inside the \code{BiocParallel} call to process
frames in parallel by taking advantage of the computing infrastructure available}
}
\value{
A \code{ParticleSet} object, containing all detected particles for each frame
}
\description{
Extracts particles from the images of a \code{Frames} object.
}
\examples{
data("MesenteriumSubset")

}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2015
}
