% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinematics.R
\name{kinematics}
\alias{kinematics}
\title{Calculate a set of kinematics parameter from a \code{TrajectorySet} object, or a single parameter, or from a single trajectory (all possible combinations)}
\usage{
kinematics(
  trajectoryset,
  trajectoryIDs = NULL,
  acquisitionFrequency = 30,
  scala = 50,
  feature = NULL
)
}
\arguments{
\item{trajectoryset}{A \code{TrajectorySet} object}

\item{trajectoryIDs}{The ID of a single trajectory}

\item{acquisitionFrequency}{The frame rate of acquisition for the images, in
milliseconds}

\item{scala}{The value of micro(?)meters to which each single pixel
corresponds}

\item{feature}{Character string, the name of the feature to be computed}
}
\value{
A \code{KinematicsFeaturesSet} object, or a \code{KinematicsFeatures} object,
or an atomic value, or a list(eventually coerced to a vector)
}
\description{
The computed set of parameters include \code{delta.x}, \code{delta.t} and \code{delta.v}
(displacements and instantaneous velocity), \code{totalTime}, \code{totalDistance},
\code{distStartToEnd}, \code{curvilinearVelocity}, \code{straightLineVelocity} and
\code{linearityForwardProgression}, Mean Squared Displacement, velocity
autocorrelation, and more. If a single trajectory is specified, the computation is
performed for that trajectory alone. If a parameter is specified, only that
parameter is reported, either for one or all trajectories
}
\examples{
data("candidate.platelets")
platelets.trajectories <- trajectories(candidate.platelets)
# for all trajectories, all features
alltrajs.features <- kinematics(platelets.trajectories)
# for one trajectory, all features
traj11features <- kinematics(platelets.trajectories,trajectoryIDs = 11)
# for all trajectories, one feature
alltrajs.curvVel <- kinematics(platelets.trajectories,feature = "curvilinearVelocity")
  
}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
