% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingHierarchy_Methods.R
\name{gh_pop_get_indices}
\alias{gh_pop_get_indices}
\alias{getIndices}
\alias{getIndices,GatingHierarchy,character-method}
\title{Get the membership indices for each event with respect to a particular gate in a GatingHierarchy}
\usage{
gh_pop_get_indices(obj, y)
}
\arguments{
\item{obj}{A \code{GatingHierarchy} representing a sample.}

\item{y}{A \code{character} giving the name or full(/partial) gating path of the population / node of interest.}
}
\value{
A logical vector of length equal to the number of events in the FCS file that determines whether each event is or is not included in the current gate.
}
\description{
Returns a logical vector that describes whether each event in a sample is included or excluded by this gate.
}
\details{
Returns a logical vector that describes whether each event in the data file is included in the given gate of this \code{GatingHierarchy}. The indices are for all events in the file, and do not reflect the population counts relative to the parent but relative to the root. To get population frequencies relative to the parent one cross-tabulate the  indices of \code{y} with the indices of its parent.
}
\note{
Generally you should not need to use \code{gh_pop_get_indices} but the more convenient methods \code{gh_pop_get_proportion} and \code{gh_pop_compare_stats} which return population frequencies relative to the parent node.
The indices returned reference all events in the file and are not directly suitable for computing population statistics, unless subsets are taken with respect to the parent populations.
}
\examples{
  \dontrun{
    #G is a gating hierarchy
    #Return the indices for population 5 (topological sort)
    gh_pop_get_indices(G,gs_get_pop_paths(G,tsort=TRUE)[5]);
}

}
\seealso{
\code{\link{gh_pop_compare_stats}}
}
