% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDescendants.R
\name{gh_pop_get_descendants}
\alias{gh_pop_get_descendants}
\alias{getDescendants}
\alias{getDescendants,GatingHierarchy-method}
\title{get all the descendant nodes for the given ancester}
\usage{
gh_pop_get_descendants(gh, node, showHidden = TRUE, ...)
}
\arguments{
\item{gh}{GatingHierarchy}

\item{node}{the node path}

\item{showHidden}{whether show hidden nodes}

\item{...}{passed to \code{getNode} call}
}
\description{
get all the descendant nodes for the given ancester
}
\examples{
library(flowWorkspace)
dataDir <- system.file("extdata",package="flowWorkspaceData")
suppressMessages(gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE)))
gh_pop_get_descendants(gs[[1]], "CD4")
gh_pop_get_descendants(gs[[1]], "CD8", path = "auto")
}
