% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingHierarchy_Methods.R
\name{gh_pop_get_data}
\alias{gh_pop_get_data}
\alias{gs_pop_get_data}
\alias{getData}
\alias{getData,GatingHierarchy-method}
\alias{getData,GatingSet-method}
\alias{getData,GatingSetList-method}
\title{get gated flow data from a GatingHierarchy/GatingSet/GatingSetList}
\usage{
gh_pop_get_data(obj, y = "root", inverse.transform = FALSE, ...)
}
\arguments{
\item{obj}{A \code{GatingHierarchy}, \code{GatingSet} or \code{GatingSetList} object.}

\item{y}{\code{character}  the node name or full(/partial) gating path.
If not specified, will return the complete flowFrame/flowSet at the root node.}

\item{inverse.transform}{logical flag indicating whether to inverse transform the data}

\item{...}{arguments passed to ncdfFlow::[[}
}
\value{
A \code{flowFrame} object if \code{obj} is a GatingHierarchy.
A \code{flowSet} or \code{ncdfFlowSet} if a \code{GatingSet}.
A \code{ncdfFlowList} if a \code{GatingSetList}.
}
\description{
get gated flow data from a GatingHierarchy/GatingSet/GatingSetList
}
\details{
Returns a flowFrame/flowSet containing the events in the gate defined at node \code{y}.
Subset membership can be obtained using \code{gh_pop_get_indices}.
Population statistics can be obtained using \code{getPop} and \code{gh_pop_compare_stats}.
When calling \code{gh_pop_get_data} on a GatingSet,the trees representing the GatingHierarchy for each sample in the GaingSet are presumed to have the same structure.
To update the data, use \code{gs_cyto_data} method.
}
\examples{
  \dontrun{
    #G is a GatingSet
    geData(G,3) #get a flowSet constructed from the third node / population in the tree.
    geData(G,"cd4")

    #gh is a GatingHierarchy
    gh_pop_get_data(gh)
}
}
\seealso{
\code{\link{gs_cyto_data}} \code{\link{gh_pop_get_indices}} \code{\link{gh_pop_compare_stats}}
}
