% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow_trans.R
\name{flowjo_biexp}
\alias{flowjo_biexp}
\alias{flowJoTrans}
\title{construct the flowJo-type biexponentioal transformation function}
\usage{
flowjo_biexp(
  channelRange = 4096,
  maxValue = 262144,
  pos = 4.5,
  neg = 0,
  widthBasis = -10,
  inverse = FALSE
)
}
\arguments{
\item{channelRange}{\code{numeric} the maximum value of transformed data}

\item{maxValue}{\code{numeric} the maximum value of input data}

\item{pos}{\code{numeric} the full width of the transformed display in asymptotic decades}

\item{neg}{\code{numeric} Additional negative range to be included in the display in asymptotic decades}

\item{widthBasis}{\code{numeric} unkown.}

\item{inverse}{\code{logical} whether to return the inverse transformation function.}
}
\description{
Normally it was parsed from flowJo xml workspace. This function provides the alternate
way to construct the flowJo version of logicle transformation function within R.
}
\examples{
trans <- flowjo_biexp()
data.raw <- c(-1, 1e3, 1e5)
data.trans <- trans(data.raw)
round(data.trans)
inv <- flowjo_biexp(inverse = TRUE)
round(inv(data.trans))
}
