% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingHierarchy_Methods.R
\name{estimateLogicle}
\alias{estimateLogicle}
\alias{estimateLogicle.GatingHierarchy}
\alias{estimateLogicle,GatingHierarchy-method}
\alias{estimateLogicle,GatingSet-method}
\title{Compute logicle transformation from the flowData associated with a GatingHierarchy}
\usage{
\method{estimateLogicle}{GatingHierarchy}(x, channels, ...)
}
\arguments{
\item{x}{a GatingHierarchy}

\item{channels}{channels or markers for which the logicle transformation is to be estimated.}

\item{...}{other arguments}
}
\value{
transformerList object
}
\description{
See details in \link[flowCore]{estimateLogicle}
}
\examples{
\dontrun{
 # gs is a GatingSet
 trans.list <- estimateLogicle(gs[[1]], c("CD3", "CD4", "CD8")) 
 # trans.list is a transformerList that can be directly applied to GatinigSet
 gs <- transform(gs, trans.list)
}
}
