% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noSummaryAnalysis.R
\name{tidyFlow}
\alias{tidyFlow}
\title{Generate a tidy dataset from time-course flow cytometry data}
\usage{
tidyFlow(flowset, gated = TRUE, ploidy = NA, only = NA)
}
\arguments{
\item{flowset}{your flowSet to be analyzed}

\item{gated}{\code{boolean} is the data already gated?}

\item{ploidy}{\code{character} gate to subset your flowset based on the
ploidy of you strains}

\item{only}{\code{character} which population of events to analyze,
'yeast', singlets', or 'doublets'?}
}
\value{
a data frame containing all of the selected subset of events from
the original flowSet for all parameters including experiment time, etime,
the time after the initial reading at which each event was collected.
}
\description{
Generates a tibble containing all parameters and phenoData
from a flowSet which can be used to visualize and
analyze timecourse flow cytometry data.
}
\examples{
plate1<-read.flowSet(path=system.file("extdata", "tc_example",
package = "flowTime"), alter.names = TRUE)
annotation <- read.csv(system.file("extdata", "tc_example.csv",
package = "flowTime"))
plate1 <- annotateFlowSet(plate1, annotation)
tidy_dat <- tidyFlow(plate1, gated = TRUE)
head(tidy_dat)

}
