% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gateCreator.R
\name{saveGates}
\alias{saveGates}
\title{Save a yeast gate set}
\usage{
saveGates(
  yeastGate = NULL,
  dipsingletGate = NULL,
  dipdoubletGate = NULL,
  hapsingletGate = NULL,
  hapdoubletGate = NULL,
  path = getwd(),
  fileName = "defaultGates.RData"
)
}
\arguments{
\item{yeastGate}{a gate object defining the population of yeast cells}

\item{dipsingletGate}{a gate object defining the population of diploid
singlet cells}

\item{dipdoubletGate}{a gate object defining the population of diploid
doublet cells}

\item{hapsingletGate}{a gate object defining the population of haploid
singlet cells}

\item{hapdoubletGate}{a gate object defining the population of haploid
doublet cells}

\item{path}{path to the folder in which you would like to save the gates}

\item{fileName}{name of the .Rdata file you would like to save these
gates within}
}
\value{
a .RData file in the "extdata" folder of the package containing
the specified gates
}
\description{
Save a yeast gate set
}
\examples{
loadGates(system.file("extdata/SORPGates.RData", package = "flowTime"))
#not run:
#saveGates()
}
