% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryAnalysis.R
\name{flsummary}
\alias{flsummary}
\title{Get summary statistics for fluorescence or other data channels of a flowSet}
\usage{
flsummary(flowset, channel)
}
\arguments{
\item{flowset}{the \code{flowSet} to create summary statistics for}

\item{channel}{option \code{character vector} of the data channel(s) to
summarize. By default all channels will be summarized. Setting channels does
not reduce computation time}
}
\value{
A \code{data frame} containing summary statistics (mean, median,
SD) for the specified fluorescent channel and time moments of the flowSet.
}
\description{
Get summary statistics for fluorescence or other data channels of a flowSet
}
\examples{
plate1 <- read.flowSet(path = system.file("extdata",
"ss_example", package = "flowTime"), alter.names = TRUE)
flsummary(flowset = plate1, channel = "FL1.A")
}
