% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillover.R
\name{spillover_ng-flowSet}
\alias{spillover_ng-flowSet}
\alias{spillover_ng}
\alias{spillover_ng,flowSet-method}
\alias{spillover_ng,missing-method}
\title{Compute a spillover matrix from a \code{flowSet}, simplified API}
\usage{
\S4method{spillover_ng}{flowSet}(x, fsc = "FSC-A", ssc = "SSC-A",
             plot = FALSE, matchfile, path,
             useNormFilt = TRUE, patt = NULL, pregate = TRUE, method = "mode", \dots)
\S4method{spillover_ng}{missing}(x, fsc = "FSC-A", ssc = "SSC-A",
             plot = FALSE, matchfile, path,
             useNormFilt = TRUE, patt = NULL, pregate = TRUE, method = "mode", \dots)

\S4method{spillover_ng}{missing}(
  x,
  fsc = "FSC-A",
  ssc = "SSC-A",
  plot = FALSE,
  matchfile,
  path,
  useNormFilt = TRUE,
  patt = NULL,
  pregate = TRUE,
  method = "mode",
  ...
)
}
\arguments{
\item{x}{A flowSet of compensation beads or cells}

\item{fsc}{The name or index of the forward scatter parameter}

\item{ssc}{The name or index of the side scatter parameter}

\item{plot}{logical. Plots the kernel density for each channel when
pregating. Displays the gate used. If \code{pregate} is set to \code{FALSE},
this argument is ignored.}

\item{matchfile}{Name of the csv file holding the compensation control file
to channel matching information.}

\item{path}{A path to a directory containing the control files, to be used 
if \code{x} is not provided.}

\item{useNormFilt}{logical Indicating whether to apply a
\code{\link{norm2Filter}} first before computing the spillover}

\item{patt}{An optional regular expression defining which parameters should
be considered}

\item{pregate}{logical Indicating whether to pregate using \code{link{rangeGate}}
before computing the spillover}

\item{method}{The statistic to use for calculation. Traditionally, this has
been the median so it is the default. The mean is sometimes more stable.}

\item{\dots}{Additional arguments passed to
\code{\link[flowStats]{rangeGate}}.}
}
\value{
A matrix for each of the parameters
}
\description{
Spillover information for a particular experiment is often obtained by
running several tubes of beads or cells stained with a single color that can
then be used to determine a spillover matrix for use with
\code{\link{compensate}}.\cr\cr
Matching stain channels to compensation controls is done via a matching csv
file (at the path given by \code{matchfile}) with columns 'filename' and 'channel'. 
The 'channel' entries should exactly match the channel names in the FCS files. 
The 'filename' should be the FCS file name of each compensation control which 
should also be the corresponding sample name in the \code{flowSet}. 
There should also be one unstained control with the 'channel' entry of 'unstained'.\cr\cr
The method also allows for \code{x} to be missing if \code{path} is provided,
pointing to a directory containing the control FCS files.\cr\cr
By default, pregating is always done on the channels using this API, and the 
mode of the channel is used to compute the spillover matrix. FSC and SSC channels 
can be provided to allow a pregating on (approximately) a population in the FSC and
SSC dimensions. Also by default, a \code{\link{norm2Filter}} is applied before
computing the spillover. These defaults can be overridden using the \code{pregate},
\code{method}, and \code{useNormFilt} arguments.
}
\details{
The algorithm used is fairly simple. First, using the scatter parameters, we
restrict ourselves to the most closely clustered population to reduce the
amount of debris. The selected statistic is then calculated on all
appropriate parameters and the unstained values swept out of the matrix.
Every sample is then normalized to [0,1] with respect to the maximum value
of the sample, giving the spillover in terms of a proportion of the primary
channel intensity.
}
\references{
C. B. Bagwell & E. G. Adams (1993). Fluorescence spectral
overlap compensation for any number of flow cytometry parameters. in: Annals
of the New York Academy of Sciences, 677:167-184.
}
\seealso{
\code{\link{compensate}}, \code{\link{spillover}}
}
\author{
B. Ellis
}
\keyword{methods}
