% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneVsAllPlot.R
\name{oneVsAllPlot}
\alias{oneVsAllPlot}
\title{Plotting all variables against a single variable}
\usage{
oneVsAllPlot(
  flowObj,
  yCol = "all",
  nRows = 10000,
  plotName = "default",
  dirName = "All_vs_all_plots",
  zeroTrim = TRUE,
  hexBins = 30,
  saveResult = TRUE
)
}
\arguments{
\item{flowObj}{This is the full dataset, either a flowFrame or a flowSet,
that should be plotted. If it has more rows than "nRows", a subsample (with
equal contributions from each sample if a flowSet) will be plotted.}

\item{yCol}{Here, the variable to be plotted against all the others is
selected. It can be either a number, the column name of interest or "all".}

\item{nRows}{The number of rows that will be used to construct the plot.
The fewer, the faster, but the resolution also decreases, naturally. Default
is 100000.}

\item{plotName}{If a name different from yCol should be used, it can be added
here.}

\item{dirName}{Add a custom directory name.}

\item{zeroTrim}{In the case of CyTOF data, the events at zero can often
be so dominant, that all other density variation is dwarfed, and thus
invisible. With this command, the events that are zero in both y
and x are trimmed for each x separately.}

\item{hexBins}{How many bins should the hexagonal plots be divided in?}

\item{saveResult}{Should the result be saved as a file?}
}
\value{
A plot with one 2D-graph for each variable that the y-variable
should be plotted against.
}
\description{
This function is useful both when setting appropriate gates and when the
adjustments of the compensation are done
}
\examples{
#' # Load uncompensated data
data(fullPanel)

# Load the spectral unmixing matrix generated with controls from the same
# experiment. These can be generated using the specMatCalc function.
data(specMat)

# Now unmix
fullPanelUnmix <- specUnmix(fullPanel, specMat)

# Transform all fluorescent channels
fullPanelTrans <- arcTrans(fullPanelUnmix,
    transNames = colnames(fullPanelUnmix)[6:18])

# And now run the function. If no specific marker is selected, as in this
# case, then all markers will be plotted in a new sub-directory.
# Further, if you leave the saveResult to TRUE, a pdf will be created.
oneVsAllPlot(fullPanelTrans, yCol = "BV650_CD56", saveResult = FALSE)

# This shows that there is a compensation artifact between AF647_IgM and
# BV650_CD56, which is an expected combination to cause problems, due to the
# similar emission characteristics. It is therefore recommended to go on to
# correctUnmix function.

}
\seealso{
\code{\link{correctUnmix}}
}
