% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlowHist.R
\name{setBins}
\alias{setBins}
\title{setBins}
\usage{
setBins(fh, bins = 256)
}
\arguments{
\item{fh}{a \code{\link{FlowHist}} object}

\item{bins}{integer, the number of bins to use in aggregating FCS data}
}
\value{
a \code{\link{FlowHist}} object, with the \code{bins} slot set
  to \code{bins}, and the corresonding binned data stored in a matrix in
  the \code{histData} slot. Any previous analysis slots are removed:
  \code{peaks, comps, model, init, nls, counts, CV, RCS}.
}
\description{
(Re-)set the bins for a FlowHist object
}
\details{
This function sets (or resets) the number of bins to use in aggregating
FCS data into a histogram, and generates the corresponding data matrix.
Not exported for general use.

The \code{histData} matrix also contains the columns corresponding to
the raw data used in calculating the single-cut and multiple-cut debris
components, as well as the doublet, triplet, and quadruplet aggregate
values. (i.e., \code{SCvals}, \code{MCvals}, \code{DBvals},
\code{TRvals}, and \code{QDvals}).

\code{\link{setBins}} includes a call to \code{\link{resetFlowHist}}, so
all the model components that depend on the bins are updated in the
process (as you want!).
}
\examples{
## defaults to 256 bins:
library(flowPloidyData) 
fh1 <- FlowHist(file = flowPloidyFiles()[1], channel = "FL3.INT.LIN")
plot(fh1)
## reset them to 512 bins:
fh1 <- setBins(fh1, 512)
plot(fh1)
}
\author{
Tyler Smith
}
