% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlowHist.R
\name{fhStart}
\alias{fhStart}
\title{Calculate the where to start analysis for a \code{\link{FlowHist}}
histogram}
\usage{
fhStart(intensity)
}
\arguments{
\item{intensity}{numeric, the fluorescence intensity channel bins}
}
\value{
an integer, the index of the first intensity element to include
  in the actual model fitting. That is, everything from \code{startBin}
  to the end of \code{intensity} gets fit in the model, everything below
  \code{startBin} is ignored.
}
\description{
We exclude the first five bins at the outset (as part of the function
\code{\link{setBins}}. For some flow cytometers, these values contain
very high spikes that are an artifact of compensation, and are not
useful data.
}
\details{
After that, we call \code{\link{fhStart}} to skip to the highest value
in the first 10 non-zero bins, and ignore everything below that. The
motivation here is the same - to get out beyond the noisy bins and into
the actual data we're trying to fit.
}
\author{
Tyler Smith
}
\keyword{internal}
