% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_flowgraph_plots.R
\name{plot_gr}
\alias{plot_gr}
\title{Plots a cell hierarchy.}
\usage{
plot_gr(
  gr,
  main = NULL,
  show_bgedges = TRUE,
  colour_palette = NULL,
  label_coloured = TRUE,
  shiny_plot = FALSE,
  interactive = FALSE,
  visNet_plot = TRUE,
  colour_edges = FALSE,
  ...
)
}
\arguments{
\item{gr}{A list containing data frames \code{e} and \code{v}.}

\item{main}{A string containing the plot title. If this is set to NULL, the
function will look for a plot title in the \code{main} slot of \code{gr};
otherwise, this defaults to "".}

\item{show_bgedges}{A logical variable indicating whether or not
edges not specified for plotting should be plotted as light grey
in the background. If this is \code{NULL}, the function will look for a
\code{show_bgedges} in the \code{show_bgedges} slot of \code{gr};
otherwise, this defaults to \code{TRUE}.}

\item{colour_palette}{A colour palette e.g. the default palette if the user
sets this to \code{NULL} is \code{c('blue','cyan','yellow','red')}.}

\item{label_coloured}{A logical indicating whether to colour the node
labels using the same colours as the nodes in the non-interactive plot.}

\item{shiny_plot}{A logical indicating whether this plot is made for shiny;
users don't need to change this.}

\item{interactive}{A logical variable indicating whether the plot should be
an interactive plot; see package \code{ggiraph}.}

\item{visNet_plot}{A logical variable indicating if an interactive plot is
chosen, if function should output a visNetwork plot; if set to \code{FALSE},
ggplot's girafe will be used instead.}

\item{colour_edges}{A logical variable indicating whether to colour edges if
plotting a node feature summary.}

\item{...}{Other parameters for \code{ggplot} if \code{interactive}
is set to \code{FALSE}; other parameters for \code{plot_ly}
if \code{interactive} is set to \code{TRUE}.}
}
\value{
A \code{ggplot} object if \code{interactive} is set to \code{FALSE};
 a \code{ggiraph} object if \code{interactive} is set to \code{TRUE}.
}
\description{
Plots a cell hierarchy given the output from \code{fg_plot}, a list of nodes and edges.
}
\examples{

 no_cores <- 1
 data(fg_data_pos2)
 fg <- flowGraph(fg_data_pos2$count, class=fg_data_pos2$meta$class,
                 no_cores=no_cores)

 # fg <- fg_summary(fg, no_cores=no_cores, class="class", control="control",
 #                  overwrite=FALSE, test_name="t_byLayer", diminish=FALSE)

 gr_summary <- fg_plot(
   fg, type="node", p_thres=.05, show_bgedges=TRUE,
   path=NULL) # set path to a full path to save plot as a PNG

 plot_gr(gr_summary, main=gr_summary$main, show_bgedges=TRUE)

 plot_gr(gr_summary, main=gr_summary$main, show_bgedges=TRUE, interactive=TRUE)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_plot}}
 \code{\link[flowGraph]{get_phen_meta}}
 \code{\link[flowGraph]{ggdf}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_get_summary}}
}
