% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_flowgraph_plots.R
\name{ggdf}
\alias{ggdf}
\title{Prepares a given node and edge graph list for plotting.}
\usage{
ggdf(gr0)
}
\arguments{
\item{gr0}{A list containing data frames \code{e} and \code{v}.}
}
\value{
A list containing data frames \code{e} and \code{v}, each
 with additional meta data column.
}
\description{
Prepares a given node and edge graph list
 for plotting by function plot_gr;
 do not use this function on its own.
}
\details{
code{ggdf} adds to the data frames \code{v} and \code{e} in slot
 \code{graph} from a \code{flowGraph} object specifying plotting options as
 required by \code{\link[flowGraph]{plot_gr}}:
 \itemize{
   \item{\code{v}}
   \itemize{
     \item{\code{size}: a numeric indicating node size.}
     \item{\code{colour}: a numeric or string indicating node colour.}
     \item{\code{label}: a string indicating the label of a node.}
     \item{\code{label_long}: a string indicating teh long label of a node;
      used in interactive plots in \code{\link[flowGraph]{plot_gr}}}.
     \item{\code{label_ind}: a vector of logical variables indicating which
      nodes to add a label to in a static plot.}
     \item{\code{v_ind}: a vector of logical variables indicating which
      nodes to plot.}
   }
   \item{\code{e}}
   \itemize{
     \item{\code{colour}: a numeric or string indicating edge colour.}
     \item{\code{e_ind}: a vector of logical variables indicating which
      edges to plot.}
   }
 }
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)

 gr_ <- ggdf(fg_get_graph(fg))
 head(gr_$v)
 head(gr_$e)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{get_phen_meta}}
 \code{\link[flowGraph]{plot_gr}}
}
